(function($) {
    'use strict';

    $(document).ready(function() {

        // Initialize copy buttons
        initCopyButtons();

        // Handle API key generation
        const generateButton = document.getElementById('generate-api-key');
        if (generateButton) {
            generateButton.addEventListener('click', function() {
                const buttonText = this.querySelector('.button-text');
                const originalText = buttonText.textContent;

                // Disable button and show loading state
                this.disabled = true;
                buttonText.textContent = 'Generating...';

                // AJAX request via jQuery
                $.ajax({
                    url: nexaWPAdmin.ajaxUrl,
                    type: 'POST',
                    data: {
                        action: 'nexawp_generate_api_key_ajax',
                        nonce: nexaWPAdmin.nonce
                    },
                    success: function(response) {
                        if (response.success && response.data.html) {
                            // Update the interface with the new key
                            const keyContainer = document.querySelector('.nexawp-no-key');
                            if (keyContainer) {
                                keyContainer.innerHTML = response.data.html;
                                // Reinitialize copy buttons after HTML update
                                initCopyButtons();
                            }
                        } else {
                            // Handle error
                            alert(response.data?.message || 'Error generating API key');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX Error:', error);
                        alert('Failed to generate API key. Please try again.');
                    },
                    complete: function() {
                        // Reset button state
                        generateButton.disabled = false;
                        buttonText.textContent = originalText;
                    }
                });
            });
        }

    });

    // Initialize copy functionality for buttons
    function initCopyButtons() {
        const copyButtons = document.querySelectorAll('.nexawp-copy-button');

        // Remove existing event listeners by cloning
        copyButtons.forEach(button => {
            const newButton = button.cloneNode(true);
            button.parentNode.replaceChild(newButton, button);

            // Add click handler to new button
            newButton.addEventListener('click', handleCopyClick);
        });
    }

    // Handle copy button click events
    function handleCopyClick() {
        const targetId = this.dataset.target;
        const input = document.getElementById(targetId);

        // Select and copy text
        input.select();
        document.execCommand('copy');

        // Show success animation
        this.classList.add('copied');
        setTimeout(() => {
            this.classList.remove('copied');
        }, 1500);

        // If copying API key, mask it after copying
        if (targetId === 'api-key' && !input.value.includes('•')) {
            const key = input.value;
            input.value = key.substring(0, 4) + '•'.repeat(key.length - 4);
            this.remove(); // Remove copy button after use
        }
    }

})(jQuery);
