<?php
// Sécurité
if (!defined('ABSPATH')) {
    exit;
}

// Récupération des options
$api_key = get_option('nexawp_api_key');
$generated_on = get_option('nexawp_api_key_generated_on');
$api_key_displayed = get_option('nexawp_api_key_displayed');
$site_url = site_url();

// Logique d’affichage masqué
$display_api_key = $api_key;
if ($api_key && $api_key_displayed === 'no') {
    update_option('nexawp_api_key_displayed', 'yes');
} else {
    if (!empty($api_key)) {
        $display_api_key = substr($api_key, 0, 4) . str_repeat('•', strlen($api_key) - 4);
    } else {
        $display_api_key = '';
    }
}
?>

<div class="nexawp-wrapper">
    <div class="nexawp-header">
        <h1><?php esc_html_e('NexaWP Manager Connection', 'nexawp-connector'); ?></h1>
    </div>

    <div class="nexawp-container">
        <!-- Card Info -->
        <div class="nexawp-card nexawp-info-card">
            <div class="nexawp-card-header">
                <span class="dashicons dashicons-info"></span>
                <h2><?php esc_html_e('Connection Information', 'nexawp-connector'); ?></h2>
            </div>
            <div class="nexawp-card-content">
                <p><?php esc_html_e('To connect your site to NexaWP Manager:', 'nexawp-connector'); ?></p>
                <ol>
                    <li><?php esc_html_e('Generate your unique API key', 'nexawp-connector'); ?></li>
                    <li><?php esc_html_e('Copy the site URL and API key', 'nexawp-connector'); ?></li>
                    <li><?php esc_html_e('Add them to your NexaWP Manager dashboard', 'nexawp-connector'); ?></li>
                </ol>
            </div>
        </div>

        <!-- Connection Details -->
        <div class="nexawp-card nexawp-connection-card">
            <div class="nexawp-card-header">
                <span class="dashicons dashicons-admin-network"></span>
                <h2><?php esc_html_e('Connection Details', 'nexawp-connector'); ?></h2>
            </div>
            <div class="nexawp-card-content">
                <!-- Site URL -->
                <div class="nexawp-field-group">
                    <label><?php esc_html_e('Site URL', 'nexawp-connector'); ?></label>
                    <div class="nexawp-copy-field">
                        <input type="text" id="site-url" value="<?php echo esc_attr($site_url); ?>" readonly>
                        <button class="nexawp-copy-button" data-target="site-url">
                            <span class="dashicons dashicons-admin-page"></span>
                            <span class="tooltip"><?php esc_html_e('Copy URL', 'nexawp-connector'); ?></span>
                        </button>
                    </div>
                </div>

                <!-- API Key -->
                <div class="nexawp-field-group">
                    <label><?php esc_html_e('API Key', 'nexawp-connector'); ?></label>
                    <?php if ($api_key): ?>
                        <div class="nexawp-copy-field">
                            <input type="text" id="api-key" value="<?php echo esc_attr($display_api_key); ?>" readonly>
                            <?php if ($api_key_displayed === 'no'): ?>
                                <button class="nexawp-copy-button" data-target="api-key">
                                    <span class="dashicons dashicons-admin-page"></span>
                                    <span class="tooltip"><?php esc_html_e('Copy Key', 'nexawp-connector'); ?></span>
                                </button>
                            <?php endif; ?>
                        </div>
                        <?php if ($generated_on): ?>
                            <div class="nexawp-key-meta">
                                <span class="dashicons dashicons-calendar"></span>
                                <?php
                                echo esc_html(sprintf(
                                    __('Generated on: %s', 'nexawp-connector'),
                                    $generated_on
                                ));
                                ?>
                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <div class="nexawp-no-key">
                            <p><?php esc_html_e('No API key generated yet.', 'nexawp-connector'); ?></p>
                            <button type="button" id="generate-api-key" class="nexawp-button">
                                <span class="dashicons dashicons-plus-alt"></span>
                                <span class="button-text"><?php esc_html_e('Generate API Key', 'nexawp-connector'); ?></span>
                            </button>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
